/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "stdafx.h"
#include "Camera.h"

CCamera::CCamera()
{
	Reset();

	vUp.X = 0.0f;
	vUp.Y = 0.0f;
	vUp.Z = 1.0f;

	fTimeElapsed = 0.0f;
	lLastTick = 0;

	fFPS = 0.0f;
	lLastFPSUpdateTick = 0;
	lFrames = 0;
	fFrameInterval = 500.0f;

	bInvertCamera = false;
}

void CCamera::InitializePerformanceCounter()
{
	fTimeElapsed = 0.0f;
	fFPS = 0.0f;
//	QueryPerformanceCounter(&lLastTick);
	lLastTick = GetTickCount();
	lLastFPSUpdateTick = lLastTick;
//	QueryPerformanceFrequency(&lFreq);
}

void CCamera::UpdateTimeElapsed()
{
	long lTick;
	float fFPSUpdateTimeElapsed;
	//QueryPerformanceCounter(&lTick);
	lTick = GetTickCount();

	fTimeElapsed = (float)(lTick - lLastTick);// / (float)(lFreq);
	fFPSUpdateTimeElapsed = (float)(lTick - lLastFPSUpdateTick);// / (float)(lFreq);
	if(fFPSUpdateTimeElapsed >= fFrameInterval) 
	{	
		fFPS = 1000.0f * (float)(lFrames) / (fFPSUpdateTimeElapsed);
		lLastFPSUpdateTick = lTick;
		lFrames = 0;
	}

	lFrames++;
	lLastTick = lTick;
}

void CCamera::MoveCameraAngles(int iAngleX, int iAngleY)
{
	if(bInvertCamera)
		iAngleX = -iAngleX;

	vAngle.X -= (float)(iAngleX) / 100.0f;
	vAngle.Y += (float)(iAngleY) / 100.0f;

	if(vAngle.X > 1.5f)  // 85.94 degrees.
		vAngle.X = 1.5f;

	if(vAngle.X < -1.5f)
		vAngle.X = -1.5f;
}

void CCamera::MoveCamera(float fWalk, float fStrafe)
{
	vPosition.X += ((float)(Math::Cos(vAngle.Y)) * fWalk * fTimeElapsed) + ((float)(Math::Cos(vAngle.Y + 1.570796f)) * fStrafe * fTimeElapsed);
	vPosition.Y += ((float)(Math::Sin(vAngle.Y)) * fWalk * fTimeElapsed) + ((float)(Math::Sin(vAngle.Y + 1.570796f)) * fStrafe * fTimeElapsed);
	vPosition.Z -= ((float)(Math::Tan(vAngle.X)) * fWalk * fTimeElapsed);
}

void CCamera::CalculateLookAt()
{
	vLookAt.X = vPosition.X + (float)(Math::Cos(vAngle.Y));
	vLookAt.Y = vPosition.Y + (float)(Math::Sin(vAngle.Y));
	vLookAt.Z = vPosition.Z - (float)(Math::Tan(vAngle.X));
}

void CCamera::SetCamera()
{
	CalculateLookAt();
	gluLookAt(vPosition.X, vPosition.Y, vPosition.Z, vLookAt.X, vLookAt.Y, vLookAt.Z, vUp.X, vUp.Y, vUp.Z);
}

void CCamera::Reset()
{
	vPosition.X = 0.0f;
	vPosition.Y = 0.0f;
	vPosition.Z = 0.0f;

	vLookAt.X = 1.0f;
	vLookAt.Y = 0.0f;
	vLookAt.Z = 0.0f;

	vAngle.X = 0.0f;
	vAngle.Y = 0.0f;
}